//Experiment-8
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim : A SCILAB program to evaluate performance of long transmission line using graphical method

clc 
clear all
disp('Rigorous Method for Long transmission line using graphical method') 
R =32 // ('Enter the Total line Resistance in Ohms : ') 
XL =50 // ('Enter the Total line Inductive Reactance in Ohms : ') 
y =0.003 // ('Enter the Total line Suseptance in Seimen : ') 
f =50 // ('Enter the frequency : ')
PR= 20e6 //('Enter the Recieving End Power in Watt : ')
VRLL=110e3 // ('Enter the Recieving End Line Voltage in Volt :')
pf=0.8,
Z=R+%i*XL;
Y= %i*y;
VR = VRLL/sqrt(3);
IR=PR/(sqrt(3)*VRLL*pf);
A = 1+ (Z*Y)/2 + (Z*Z*Y*Y)/24;    //A= cosh(sqrt(Y*Z))

B = sqrt(Y*Z) + ((Y*Z)^(3/2))/6;    //B = sinh(sqrt(Y*Z))

pf = 1:-0.01:0.5


Irang = acos (pf);	// Angle in radian

Ir =IR * exp (-%i*Irang);
Ir1 =IR * exp (%i*Irang);


VS = VR*A + Ir*sqrt(Z/Y)*B;    //VS = VR*cosh(sqrt(Y*Z)) + IR*sqrt(Z/Y)*sinh(sqrt(Y*Z))

VS1 = VR*A + Ir1*sqrt(Z/Y)*B ;   //VS = VR*cosh(sqrt(Y*Z)) + IR*sqrt(Z/Y)*sinh(sqrt(Y*Z))


[VS_abs,Phase_VS]= polar(VS);
[VS1_abs,Phase_VS1]= polar(VS1);

VSLL=VS;
VSLL1=VS1;
REGlag = 100*((abs (VSLL) - abs (VR)))/ abs (VR)
REGlead = 100*((abs (VSLL1) - abs (VR)))/ abs (VR)


plot(pf,REGlag,'g-');
plot(pf,REGlead,'b'); 

xlabel('power factor') 
ylabel('voltage regulation')
title('Long Transmission line voltage regulation') 
legend('Lagging Power Factor','Leading Power Factor')

